from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

class TurboMWGG(PYBaseGamePlay):
	def __init__(self):
		super(TurboMWGG, self).__init__()

		self.GGClass = 'weapon_golden_gun'
		self.GGOwner = None
		
		self.GGGlow = GEUtil.CColor(232, 180, 2, 64)
		self.GGColor = GEUtil.CColor(232, 180, 2, 255)

	def GetPrintName(self):
		return "TurboMWGG"

	def GetHelpString(self):
		return "#GES_GP_MWGG_HELP"

	def GetGameDescription(self):
		return "TurboMWGG"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_NONE

	def OnLoadGamePlay(self):
		GEMPGameRules.GetTokenMgr().AddTokenType( self.GGClass, 1, GEGlobal.SPAWN_WEAPON | GEGlobal.SPAWN_SPECIALONLY )
		GEMPGameRules.GetTokenMgr().SetTokenGlow( self.GGClass, True, self.GGGlow )
		GEMPGameRules.GetTokenMgr().SetTokenRespawnDelay( self.GGClass, 20 )
		GEMPGameRules.GetRadar().SetForceRadar( True )
		self.LoadConfig()
		self.CreateCVar("ge_velocity", "1.5", "Velocity (speed) multiplier, range from 0.5 to 1.5.")

	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()
		
	def OnRoundEnd(self):
		GEMPGameRules.GetRadar().DropAllContacts()
		
	def OnPlayerSpawn(self, player):
		player.SetMaxArmor( int(GEGlobal.GE_MAX_ARMOR) )
		player.SetSpeedMultiplier( float(GEUtil.GetCVarValue("ge_velocity")) )

	def OnPlayerKilled(self, victim, killer, weapon):

		#what exactly got killed?
		if not victim:
			return

		#death by world
		if not killer:
			victim.IncrementScore( -1 )
			return

		if victim.GetIndex() == killer.GetIndex():
			# Suicide
			if self.GGOwner is not None and killer.GetIndex() == self.GGOwner.GetIndex():
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "#GES_GP_MWGG_SUICIDE")
			
			killer.IncrementScore( -1 )

		else:
			# Legit Kill
			if self.GGOwner is not None and victim.GetIndex() == self.GGOwner.GetIndex():
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "#GES_GP_MWGG_KILLED", killer.GetPlayerName())

			killer.IncrementScore( 1 )


	def OnThink(self):
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue

			player = GEUtil.GetMPPlayer(i)
			if player.GetArmor() > 0:
				# We set 159 as a flag to say the player has the GG. Their max armor
				# will be instantly truncated as soon as they pick up armor or if they
				# had left over armor before they picked up the gun
				if  player.GetMaxArmor() == 159:
					player.SetMaxArmor( 0 )
			
	def OnTokenSpawned(self, token):
		GEMPGameRules.GetRadar().AddRadarContact( token, GEGlobal.RADAR_TYPE_TOKEN, True, "ge_radar_gg" )
		
	def OnTokenPicked(self, token, player):
		radar = GEMPGameRules.GetRadar()
		radar.DropRadarContact( token )
		
		radar.AddRadarContact( player, GEGlobal.RADAR_TYPE_PLAYER, True, "", self.GGColor )
		
		GEUtil.PlaySoundToPlayer(player, "GEGamePlay.Token_Grab")
		GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "#GES_GP_MWGG_PICKED", player.GetPlayerName() )
		
		radar.SetPlayerRangeMod( player, 0.5 )
		player.SetMaxArmor(159)
		
	def OnTokenDropped(self, token, player):
		radar = GEMPGameRules.GetRadar()
		
		radar.DropRadarContact( player )
		radar.AddRadarContact( token, GEGlobal.RADAR_TYPE_TOKEN, True, "ge_radar_gg" )
		
		GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "#GES_GP_MWGG_DROPPED", player.GetPlayerName() )
		
	def OnTokenRemoved(self, token):
		GEMPGameRules.GetRadar().DropRadarContact( token )
		GEMPGameRules.GetRadar().DropRadarContact( token.GetOwner() )

	def SetMaxArmor(self, ammount):
		for i in range(32):

			if not GEUtil.IsValidPlayerIndex(i):
				continue

			player = GEUtil.GetMPPlayer(i)
			player.SetMaxArmor(ammount)

	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == "gg_deathmatch" and int(newvalue) > 0:
			GEMPGameRules.EndRound()
		if name == "ge_velocity":
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				player.SetSpeedMultiplier( float(newvalue) )